package game;

import java.io.BufferedReader;
import java.io.IOException;


public class ItemSpawnPoint {
	
	private int x;
	private int y;
	private int type;
	
	
	private ItemSpawnPoint() {
		
	}


	public int getX() {
		return x;
	}


	public int getY() {
		return y;
	}


	public int getType() {
		return type;
	}
	
	
	public static ItemSpawnPoint readFromFile(BufferedReader in) throws IOException {
		
		ItemSpawnPoint returnValue = new ItemSpawnPoint();
		
		String inputter;
		
		while((inputter = in.readLine()) != null) {
			if(inputter.contains("/item")) {
				break;
			} else if(inputter.contains("x:")) {
				returnValue.x = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
				returnValue.y = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("heart")) {
				returnValue.type = ItemSprite.HEART;
			} else if(inputter.contains("checkpoint")) {
				returnValue.type = ItemSprite.CHECKPOINT_FLAG;
			}
		}
		
		return returnValue;
		
	}
	
}
